<?php
session_start();
require 'conexion.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validar CSRF token
    if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
        die('Token CSRF inválido');
    }

    // Limpiar y validar inputs
    $username = filter_input(INPUT_POST, 'username', FILTER_SANITIZE_STRING);
    $password = $_POST['password'];

    // Validaciones
    if (empty($username) || empty($password)) {
        die('Por favor complete todos los campos');
    }

    // Buscar usuario en la base de datos
    try {
        $stmt = $pdo->prepare("SELECT id, username, password FROM usuarios WHERE username = :username LIMIT 1");
        $stmt->bindParam(':username', $username, PDO::PARAM_STR);
        $stmt->execute();

        if ($stmt->rowCount() === 1) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verificar contraseña
            if (password_verify($password, $user['password'])) {
                // Regenerar ID de sesión para prevenir fixation
                session_regenerate_id(true);

                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];

                header('Location: Carnetizacion/index.php'); // Redirigir al dashboard protegido
                exit;
            }
        }

        // Error genérico para no revelar información
        header('Location: index.php?error=Credenciales incorrectas');
        exit;

    } catch (PDOException $e) {
        error_log("Error de login: " . $e->getMessage());
        die('Error en el sistema');
    }
} else {
    header('Location: index.php');
    exit;
}