<?php
// Habilitar la visualización de errores
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start(); // Iniciar sesión

// Verificar si el usuario ha iniciado sesión
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php'); // Redirigir al login si no ha iniciado sesión
    exit();
}

// Incluir la conexión a la base de datos
require '../conexion.php';

// Verificar si la conexión a la base de datos es válida
if (!$pdo) {
    die("Error: No se pudo conectar a la base de datos.");
}

$personal = null;
$mensaje = ''; // Mensaje para mostrar al usuario

// Procesar la búsqueda
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['btnbuscar'])) {
    $busqueda = trim($_POST['txtbusqueda']); // Eliminar espacios en blanco al inicio y final

    // Validar que la búsqueda no esté vacía
    if (empty($busqueda)) {
        $mensaje = "Por favor, ingrese un código o correo para buscar.";
    } else {
        // Validar si la búsqueda es un correo válido o un código alfanumérico
        if (filter_var($busqueda, FILTER_VALIDATE_EMAIL)) {
            // Es un correo válido
            $campo = 'correo';
        } elseif (preg_match('/^[a-zA-Z0-9]+$/', $busqueda)) {
            // Es un código alfanumérico
            $campo = 'codigo';
        } else {
            $mensaje = "El valor ingresado no es un correo válido ni un código alfanumérico.";
        }

        // Si no hay mensaje de error, proceder con la búsqueda
        if (empty($mensaje)) {
            try {
                // Consultar la base de datos
                $query = "SELECT * FROM personal WHERE $campo = ?";
                $stmt = $pdo->prepare($query);
                $stmt->execute([$busqueda]);

                if ($stmt->rowCount() > 0) {
                    $personal = $stmt->fetch(PDO::FETCH_ASSOC); // Obtener los datos del personal
                    $mensaje = "Datos encontrados correctamente.";
                } else {
                    $mensaje = "No se encontraron resultados para la búsqueda: " . htmlspecialchars($busqueda);
                }
            } catch (PDOException $e) {
                $mensaje = "Error en la consulta a la base de datos: " . $e->getMessage();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <title>CREDENCIALES</title>

    <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="bootstrap/css/bootstrap-theme.min.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
</head>
<body>

    <section>
        <div class="container">
            <div class="fondo">
                <h3>USUARIO<small> / ITAE </small></h3>
                <p>Bienvenido, <?= htmlspecialchars($_SESSION['username'], ENT_QUOTES) ?></p>
                <a href="https://genova.edu.pe/Credenciales2/logout.php" class="btn btn-danger">Cerrar Sesión</a>
            </div>
            <br/>

            <p>Al hacer uso de este sistema de generación de Credenciales o carnet de personal, usted está aceptando los términos y condiciones del servicio, así como las políticas de privacidad de la información LEY 29733.</p>

            <!-- Mostrar mensajes al usuario -->
            <?php if (!empty($mensaje)): ?>
                <div class="alert alert-info">
                    <?= $mensaje ?>
                </div>
            <?php endif; ?>

            <!-- Formulario de búsqueda -->
            <form action="index.php" method="POST">
                <div class="row">
                    <div class="col-sm-8">
                        <div class="col-sm-3">
                            <label>Buscar por Código o Correo:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtbusqueda" id="txtbusqueda" placeholder="Ingrese código o correo" required>
                        </div>
                        <div class="col-sm-2">
                            <input type="submit" class="btn btn-primary" name="btnbuscar" id="btnbuscar" value="Buscar">
                        </div>
                    </div>
                </div>
            </form>
            <br/>

            <!-- Formulario principal -->
            <form action="generar_carnet.php" method="POST" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-sm-8">
                        <!-- Campo Código -->
                        <div class="col-sm-3">
                            <label>Código:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtcodigo" id="txtcodigo" placeholder="Ingrese código" value="<?= $personal ? $personal['codigo'] : '' ?>" required>
                        </div>
                        <br/><br/>

                        <!-- Campo Correo -->
                        <div class="col-sm-3">
                            <label>Correo:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="email" class="form-control" name="txtcorreo" id="txtcorreo" placeholder="Ingrese correo institucional" value="<?= $personal ? $personal['correo'] : '' ?>" required autofocus>
                        </div>
                        <br/><br/>

                        <!-- Campo Nombres -->
                        <div class="col-sm-3">
                            <label>Nombres:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtnombres" id="txtnombres" placeholder="Ingrese Nombres" value="<?= $personal ? $personal['nombres'] : '' ?>" required>
                        </div>
                        <br/><br/>

                        <!-- Campo Apellidos -->
                        <div class="col-sm-3">
                            <label>Apellidos:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtapellidos" id="txtapellidos" placeholder="Ingrese Apellidos" value="<?= $personal ? $personal['apellidos'] : '' ?>" required>
                        </div>
                        <br/><br/>

                        <!-- Campo Área -->
                        <div class="col-sm-3">
                            <label>Área:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" name="txtarea" id="txtarea" placeholder="Ingrese área de labor" value="<?= $personal ? $personal['area'] : '' ?>" required>
                        </div>
                        <br/><br/>

                        <!-- Campo Imagen -->
                        <div class="col-sm-3">
                            <label>Imagen del personal:</label>
                        </div>
                        <div class="col-sm-5">
                            <input type="file" class="form-control" name="imagenPersonal" id="imagenPersonal" accept="image/*">
                            <?php if ($personal && !empty($personal['direccion_imagen'])): ?>
                                <!-- Mostrar la imagen si existe -->
                                <img src="<?= $personal['direccion_imagen'] ?>" alt="Imagen del personal" style="max-width: 500px; margin-top: 10px;">
                                <!-- Campo oculto para enviar la ruta de la imagen -->
                                <input type="hidden" name="direccion_imagen" value="<?= $personal['direccion_imagen'] ?>">
                            <?php endif; ?>
                        </div>
                        <br/><br/>
                    </div>
                </div>
                <br/>
                <div class="row">
                    <div class="form-group">
                        <input type="submit" class="btn btn-primary" name="btngrabar" id="btngrabar" value="Generar Carnet">
                    </div>
                </div>
            </form>
            <br/>
        </div>
    </section>

    <script src="js/jquery-1.11.2.min.js"></script>
    <script src="bootstrap/js/bootstrap.min.js"></script>

</body>
</html>