<?php
// Obtener los datos del formulario
$codigo  = isset($_POST['txtcodigo']) ? $_POST['txtcodigo'] : '';
$correo  = isset($_POST['txtcorreo']) ? $_POST['txtcorreo'] : '';
$nombres = isset($_POST['txtnombres']) ? $_POST['txtnombres'] : '';
$apellidos = isset($_POST['txtapellidos']) ? $_POST['txtapellidos'] : '';
$area    = isset($_POST['txtarea']) ? $_POST['txtarea'] : '';
$direccion_imagen = isset($_POST['direccion_imagen']) ? $_POST['direccion_imagen'] : ''; // Ruta de la imagen de la búsqueda
$font    = 'fonts/arial.ttf';
$design  = 'img/carnet1.png';
$file    = 'carnet/' . $codigo . '.png';
$type    = 'EAN13';

// Formatear el código para el código de barras
if (strlen($codigo) == 12) {
    $code = $codigo;
} else if (strlen($codigo) < 12) {
    $code = str_repeat('0', 12 - strlen($codigo)) . $codigo;
} else {
    $code = substr($codigo, 1, 12);
}

// Recibir y validar la imagen subida
$imgPersonal = null;

// Si se sube una nueva imagen, usarla
if (isset($_FILES['imagenPersonal']) && $_FILES['imagenPersonal']['error'] === UPLOAD_ERR_OK) {
    $tmp_name = $_FILES['imagenPersonal']['tmp_name'];
    $fileSize = $_FILES['imagenPersonal']['size'];
    $fileType = strtolower(pathinfo($_FILES['imagenPersonal']['name'], PATHINFO_EXTENSION));

    if ($fileSize > 900 * 1024 || !in_array($fileType, ['jpg', 'jpeg', 'png'])) {
        die("Error: La imagen debe ser un archivo JPG o PNG con un tamaño máximo de 900KB.");
    }

    $imgPersonal = imagecreatefromstring(file_get_contents($tmp_name));
} elseif (!empty($direccion_imagen)) {
    // Si no se sube una nueva imagen, usar la imagen de la búsqueda
    $imgPersonal = imagecreatefromstring(file_get_contents($direccion_imagen));
} else {
    // Si no hay ninguna imagen, usar la imagen por defecto
    $imgPersonal = imagecreatefromjpeg('img/user.jpg');
}

// Función para generar el código de barras
function generarCodigoDeBarras($code, $font = 'fonts/arial.ttf') {
    include('barcode/php-barcode.php');
    $fontSize = 15;
    $marge = 8;
    $x = 275;
    $y = 55;
    $height = 90;
    $width = 5;
    $angle = 0;
    $type = 'EAN13';

    $im = imagecreatetruecolor(550, 140);
    $black = ImageColorAllocate($im, 0x00, 0x00, 0x00);
    $white = ImageColorAllocate($im, 0xff, 0xff, 0xff);
    $blue = ImageColorAllocate($im, 0x00, 0x00, 0xff);
    imagefilledrectangle($im, 0, 0, 550, 140, $white);

    $data = Barcode::gd($im, $black, $x, $y, $angle, $type, array('code' => $code), $width, $height);

    if (isset($font)) {
        $box = imagettfbbox($fontSize, 0, $font, $data['hri']);
        $len = $box[2] - $box[0];
        Barcode::rotate(-$len / 2, ($data['height'] / 2) + $fontSize + $marge, $angle, $xt, $yt);
        imagettftext($im, $fontSize, $angle, $x + $xt, $y + $yt, $blue, $font, $data['hri']);
    }

    ob_start();
    imagepng($im);
    $barcode_image = ob_get_clean();
    imagedestroy($im);
    return $barcode_image;
}

// Generar la imagen del carnet
$img = imagecreatefrompng($design);
$barcode_image = generarCodigoDeBarras($code, $font);
$barcode = imagecreatefromstring($barcode_image);

// Coordenadas para la imagen del personal
$x_personal = (636 - 400) / 2; // Centrado horizontalmente
$y_personal = 50;  // 100px desde el borde superior
$ancho_personal = 400;
$alto_personal = 500;
$tamano = getimagesize('img/user.jpg'); 

// Copiar y redimensionar la imagen del personal
imagecopyresampled($img, $imgPersonal, $x_personal, $y_personal, 0, 0, $ancho_personal, $alto_personal, $tamano[0], $tamano[1]);

$black = ImageColorAllocate($img, 0x00, 0x00, 0x00); 
$white = ImageColorAllocate($img, 0xff, 0xff, 0xff);
$x_offset = (636 - 300) / 2; // Centrado horizontalmente
$y_start = $y_personal + $alto_personal + 150; // 50px debajo de la imagen
$y_increment = 40; // Espaciado vertical entre líneas de texto

// Función para centrar texto horizontalmente
function centrarTextoHorizontal($texto, $tamanioFuente, $fuente, $anchoImagen) {
    // Obtener las dimensiones del texto
    $bbox = imagettfbbox($tamanioFuente, 0, $fuente, $texto);
    $anchoTexto = $bbox[2] - $bbox[0]; // Ancho del texto

    // Calcular la posición centrada
    $x = ($anchoImagen - $anchoTexto) / 2;
    return $x;
}

// Ancho de la imagen del carnet (ajusta según tu diseño)
$anchoImagen = 636; // Ancho de la imagen base (carnet1.png)

// Centrar cada campo de texto
$x_nombres = centrarTextoHorizontal($nombres ? $nombres : "Nombres", 30, $font, $anchoImagen);
$x_apellidos = centrarTextoHorizontal($apellidos ? $apellidos : "Apellidos", 30, $font, $anchoImagen);
$x_area = centrarTextoHorizontal($area ? $area : "Área", 25, $font, $anchoImagen);
$x_correo = centrarTextoHorizontal($correo ? $correo : "Correo", 20, $font, $anchoImagen);

// Posicionamiento de Texto Mejorado (texto centrado)
imagettftext($img, 30, 0, $x_nombres, $y_start, $white, $font, $nombres ? $nombres : "Nombres"); // Nombres
imagettftext($img, 30, 0, $x_apellidos, $y_start + $y_increment, $white, $font, $apellidos ? $apellidos : "Apellidos"); // Apellidos
imagettftext($img, 25, 0, $x_area, $y_start + 2 * $y_increment, $white, $font, $area ? $area : "Área"); // Área
imagettftext($img, 20, 0, $x_correo, $y_start + 3 * $y_increment, $white, $font, $correo ? $correo : "Correo"); // Correo


// Coordenadas para el código de barras
$x_barcode = (636 - 550) / 2; // Centrado horizontalmente
$y_barcode = $y_start + 4 * $y_increment - 5; // Subí el código de barras 30px más arriba

imagecopy($img, $barcode, $x_barcode, $y_barcode, 0, 0, 550, 140);

// Guardar la imagen del carnet
imagepng($img, $file);

// Mostrar la imagen generada
header('Content-Type: image/png');
imagepng($img);

// Liberar memoria
imagedestroy($img);
imagedestroy($barcode);
imagedestroy($imgPersonal);
?>