<?php
    $codigo  = isset($_POST['txtcodigo']) ? $_POST['txtcodigo'] : '';
    $nombres = isset($_POST['txtnombres']) ? $_POST['txtnombres'] : '';
    $paterno = isset($_POST['txtapellidop']) ? $_POST['txtapellidop'] : '';
    $materno = isset($_POST['txtapellidom']) ? $_POST['txtapellidom'] : '';
    $cargo   = isset($_POST['txtcargo']) ? $_POST['txtcargo'] : '';
    $font    = 'fonts/arial.ttf';
    $design  = 'img/carnet1.png';
    $file    = 'carnet/' . $codigo . '.png';
    $type    = 'EAN13';

    // Formatear el código (Esta parte permanece sin cambios)
    if (strlen($codigo) == 12) {
        $code = $codigo;
    } else if (strlen($codigo) < 12) {
        $code = str_repeat('0', 12 - strlen($codigo)) . $codigo;
    } else {
        $code = substr($codigo, 1, 12);
    }

    // Recibir y validar la imagen subida (Esta parte permanece sin cambios)
    $imgEstudiante = imagecreatefromjpeg('img/user.jpg'); 
    if (isset($_FILES['imagenEstudiante']) && $_FILES['imagenEstudiante']['error'] === UPLOAD_ERR_OK) {
        $tmp_name = $_FILES['imagenEstudiante']['tmp_name'];
        $fileSize = $_FILES['imagenEstudiante']['size'];
        $fileType = strtolower(pathinfo($_FILES['imagenEstudiante']['name'], PATHINFO_EXTENSION));

        if ($fileSize > 900 * 1024 || !in_array($fileType, ['jpg', 'jpeg', 'png'])) {
            die("Error: La imagen debe ser un archivo JPG o PNG con un tamaño máximo de 900KB.");
        }

        $imgEstudiante = imagecreatefromstring(file_get_contents($tmp_name));
    }

    // Función para generar el código de barras (Esta parte permanece sin cambios)
    function generarCodigoDeBarras($code, $font = 'fonts/arial.ttf') {
        include('barcode/php-barcode.php');
        $fontSize = 20;
        $marge = 8;
        $x = 275;
        $y = 55;
        $height = 90;
        $width = 5;
        $angle = 0;
        $type = 'EAN13';

        $im = imagecreatetruecolor(550, 140);
        $black = ImageColorAllocate($im, 0x00, 0x00, 0x00);
        $white = ImageColorAllocate($im, 0xff, 0xff, 0xff);
        $blue = ImageColorAllocate($im, 0x00, 0x00, 0xff);
        imagefilledrectangle($im, 0, 0, 550, 140, $white);

        $data = Barcode::gd($im, $black, $x, $y, $angle, $type, array('code' => $code), $width, $height);

        if (isset($font)) {
            $box = imagettfbbox($fontSize, 0, $font, $data['hri']);
            $len = $box[2] - $box[0];
            Barcode::rotate(-$len / 2, ($data['height'] / 2) + $fontSize + $marge, $angle, $xt, $yt);
            imagettftext($im, $fontSize, $angle, $x + $xt, $y + $yt, $blue, $font, $data['hri']);
        }

        ob_start();
        imagepng($im);
        $barcode_image = ob_get_clean();
        imagedestroy($im);
        return $barcode_image;
    }


    // Generar la imagen del carnet
    $img = imagecreatefrompng($design);
    $barcode_image = generarCodigoDeBarras($code, $font);
    $barcode = imagecreatefromstring($barcode_image);

    // Coordenadas para la imagen del estudiante (AJUSTAR SEGÚN TU DISEÑO)
    $x_estudiante = 26;
    $y_estudiante = 102;
    $ancho_estudiante = 356;
    $alto_estudiante = 475;
    $tamano = getimagesize('img/user.jpg'); 

    imagecopyresampled($img, $imgEstudiante, $x_estudiante, $y_estudiante, 0, 0, $ancho_estudiante, $alto_estudiante, $tamano[0], $tamano[1]);

    $black = ImageColorAllocate($img, 0x00, 0x00, 0x00); 
    $x_offset = 420; // Coordenada X para el texto
    $y_start = 220; // Coordenada Y inicial para el texto
    $y_increment = 77; // Espaciado vertical entre líneas de texto

    // Posicionamiento de Texto Mejorado
    imagettftext($img, 20, 0, $x_offset, $y_start, $black, $font, $paterno ? $paterno : "Apellido Paterno");
    imagettftext($img, 20, 0, $x_offset, $y_start + $y_increment, $black, $font, $materno ? $materno : "Apellido Materno");
    imagettftext($img, 20, 0, $x_offset, $y_start + 2 * $y_increment, $black, $font, $nombres ? $nombres : "Nombres");
    imagettftext($img, 20, 0, $x_offset, $y_start + 3 * $y_increment, $black, $font, $cargo ? $cargo : "Cargo");

    imagecopy($img, $barcode, 440, 505, 0, 0, 550, 140);

    imagepng($img, $file);
    header('Content-Type: image/png');
    imagepng($img);
    imagedestroy($img);
    imagedestroy($barcode);
    imagedestroy($imgEstudiante);

?>